#include <stdio.h>
#include <fcntl.h>
#include "formats.h"

int main(void) {
  int fd;
  unsigned char alpha[1000], bcd[1000];
  char bytes[1000];
  int recv, i;
  long written;

  fd = open("/dev/paraseat0", O_RDWR);
  if (fd == -1)
    exit(1);

  recv = read(fd, alpha, 1000);
  for (i = 0; i < recv; i++) {
    alpha[i] = ~alpha[i];
    bcd[i] = alpha[i];
    alpha[i] = (alpha[i] & 0x01);
    bcd[i] = ((bcd[i] >> 1) & 0x01);
  }

  written = ansi_iso_alpha(bytes, alpha, recv, 1000, 1);
  if (written >= 0) {
    if (written < 1000)
      bytes[written] = 0;
    else
      bytes[999] = 0;
    printf("track 1: %s\n", bytes);
  }
  else if (written == -1)
    printf("track 1: bad checksum\n");
  else
    printf("track 1: bad LRC\n");

  written = ansi_iso_bcd(bytes, bcd, recv, 1000, 1);
  if (written >= 0) {
    if (written < 1000)
      bytes[written] = 0;
    else
      bytes[999] = 0;
    printf("track 2: %s\n", bytes);
  }
  else if (written == -1)
    printf("track 2: bad checksum\n");
  else
    printf("track 2: bad LRC\n");

  close(fd);
  return 0;
}
